import turtle
import math

def cuadrado(largo):
	"""
	cuadrado: num -> None
	dibuja un cuadrado en la position actual de la tortuga
	ejemplo: cuadrado(100) dibuja un cuadrado de 100 pixeles de lados
	"""
	turtle.forward(largo)
	turtle.left(90)
	turtle.forward(largo)
	turtle.left(90)
	turtle.forward(largo)
	turtle.left(90)
	turtle.forward(largo)
	turtle.left(90)

def cuadrado2(largo):
	"""
	cuadrado2: num -> None
	dibuja un cuadrado en la position actual de la tortuga
	ejemplo: cuadrado2(100) dibuja un cuadrado de 100 pixeles de lado
	"""
	i = 0
	while i < 4:
		turtle.forward(largo)
		turtle.left(90)
		i = i + 1

def poligono(largo, lados):
	"""
	poligono: num num -> None
	dibuja un poligono regular en la position actual de la tortuga
	ejemplos: 
	poligono(100, 3) dibuja un triangulo equilatero, de 100 pixeles de lado
	poligono(100, 4) dibuja un cuadrado
	poligono(100, 5) dibuja un pentagono
	"""
	angulo = 360.0 / lados
	i = 0
	while i < lados:
		turtle.forward(largo)
		turtle.left(angulo)
		i = i + 1

def circulo(radio):
	"""
	circulo: num -> None
	dibuja un circulo de radio definido
	ejemplo: circulo(100) dibuja un circulo de radio 100
	"""
	circumferencia = math.pi * 2 * radio
	lados = 360.0
	largo = circumferencia / lados
	poligono(largo, lados)

def circulo2(radio):
	"""
	circulo2: num -> None
	dibuja un circulo de radio definido
	se adapta al tamanho del circulo
	ejemplo: circulo2(100) dibuja un circulo de radio 100
	"""
	circumferencia = 2 * math.pi * radio
	lados = 1 + int(circumferencia / 3)
	largo = circumferencia / lados
	poligono(largo, lados)

def arco(radio, angulo):
	"""
	arco: num num -> None
	dibuja un arco de radio y angulo definido
	una generalizacion de circulo
	ejemplos: 
	arco(100, 180) dibuja un arco de radio 100, y angulo 180
	arco(100, 360) dibuja un circulo
	"""
	largo = 2 * math.pi * radio * angulo / 360
	lados = 1 + int(largo / 3)
	paso_largo = largo / lados
	paso_angulo = float(angulo) / lados
	i = 0
	while i < lados:
		turtle.forward(paso_largo)
		turtle.left(paso_angulo)

def polilinea(lados, largo, angulo):
	"""
	polilinea: num num num -> None
	dibuja una parte de poligono, girando del angulo entre cada paso
	una generalizacion de poligono
	ejemplos:
	polilinea(3, 100, 90) dibuja un "C"
	polilinea(4, 100, 90) dibuja un cuadrado
	"""
	i = 0
	while i < lados:
		turtle.forward(largo)
		turtle.left(angulo)
		i = i + 1

def poligono2(lados, largo):
	"""
	poligono: num num -> None
	dibuja un poligono regular en la position actual de la tortuga
	usa polilinea
	ejemplos: 
	poligono(100, 3) dibuja un triangulo equilatero, de 100 pixeles de lado
	poligono(100, 4) dibuja un cuadrado
	poligono(100, 5) dibuja un pentagono
	"""
	angulo = 360 / lados
	polilinea(lados, largo, angulo)

def arco2(radio, angulo):
	"""
	arco2: num num -> None
	dibuja un arco de radio y angulo definido
	una generalizacion de circulo
	ejemplos: 
	arco2(100, 180) dibuja un arco de radio 100, y angulo 180
	arco2(100, 360) dibuja un circulo
	"""
	largo = 2 * math.pi * radio * angulo / 360
	lados = 1 + int(largo / 3)
	paso_largo = largo / lados
	paso_angulo = float(angulo) / lados
	polilinea(lados, paso_largo, paso_angulo)

def circulo3(radio):
	"""
	circulo: num -> None
	dibuja un circulo de radio definido, usando arco
	ejemplo: circulo(100) dibuja un circulo de radio 100
	"""
	arco2(radio, 360)
	

def limpiar(): turtle.clear()
turtle.speed(10)
